unit SearchTreeviewDemoMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, gtroSearchTreeview, ExtCtrls;

type
  TFormSearchTreeview = class(TForm)
    TV: TGtroSearchTreeview;
    SearchBox: TEdit;
    btnLoad: TButton;
    FileOpenDialog: TFileOpenDialog;
    btnSave: TButton;
    RadioGroupSelect: TRadioGroup;
    LabelSearchBox: TLabel;
    StatusBar: TStatusBar;
    FileSaveDialog: TFileSaveDialog;
    procedure btnLoadClick(Sender: TObject);
    procedure btnSaveClick(Sender: TObject);
    procedure TVSearchModeChanged(Sendet: TObject; SearchMode: Boolean);
    procedure RadioGroupSelectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure TVLeafNodeChecked(Sender: TObject; Node: TTreeNode);
    procedure TVCustomDrawItem(Sender: TCustomTreeView; Node: TTreeNode;
      State: TCustomDrawState; var DefaultDraw: Boolean);
  private
    FileName: string;
  public
    { Public declarations }
  end;

var
  FormSearchTreeview: TFormSearchTreeview;

implementation

{$R *.dfm}

procedure TFormSearchTreeview.btnLoadClick(Sender: TObject);
begin
  if FileOpenDialog.Execute then
  begin
    FileName:= FileOpenDialog.FileName;
    TV.LoadFromFile(FileName);
    StatusBar.Panels[0].Text:= ExtractFileName(FileName);
  end;
end;

procedure TFormSearchTreeview.btnSaveClick(Sender: TObject);
begin
  if not TV.SearchMode then
  begin
    FileSaveDialog.FileName:= FileName;
    if FileSaveDialog.Execute then
      TV.SaveToFile(FileName);
  end;
end;

procedure TFormSearchTreeview.FormCreate(Sender: TObject);
begin
  RadioGroupSelectClick(Self);
end;

procedure TFormSearchTreeview.RadioGroupSelectClick(Sender: TObject);
var
  Path: string;
  i: Integer;
begin
  Path:= ExtractFilePath(Application.ExeName);
  Path:= Copy(Path, 0, Length(Path) - 1);
  for i:= Length(Path) downto 0 do
    if Path[i] = '\' then
      Break;
  Path:= Copy(Path, 0, i);
  if RadioGroupSelect.ItemIndex = 0 then
  begin
    FileName:= Path + '\data\TVToolPalette.txt';
    TV.LoadFromFile(FileName);
  end
  else
  begin
    FileName:= Path + '\data\TVMultiLevels.txt';
    TV.LoadFromFile(FileName);
  end;
  StatusBar.Panels[0].Text:= ExtractFileName(FileName);
end;

procedure TFormSearchTreeview.TVCustomDrawItem(Sender: TCustomTreeView;
  Node: TTreeNode; State: TCustomDrawState; var DefaultDraw: Boolean);
begin
  DefaultDraw:= true;
  if (cdsSelected in State) and (not Node.HasChildren) then
  begin
    TV.Canvas.Brush.Color := clYellow;
    TV.Canvas.Font.Color := clRed;
    TV.Canvas.Font.Style := [fsBold];
  end
  else
  begin
    TV.Canvas.Brush.Color := clWindow;
    TV.Canvas.Font.Color := clWindowText;
  end;
end;

procedure TFormSearchTreeview.TVLeafNodeChecked(Sender: TObject;
  Node: TTreeNode);
begin
  StatusBar.Panels[1].Text:= '"' + Node.Text + '" selected';
end;

procedure TFormSearchTreeview.TVSearchModeChanged(Sendet: TObject;
  SearchMode: Boolean);
begin
  btnSave.Enabled:= not SearchMode;
end;

end.
