unit GtroDBReg;

{$I GtroDBLib.INC}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, db;


procedure Register;

implementation

uses
  GtroDBDateTimePicker, GtroDBPushButtonCalendar, GtroDBTreeView
  {$IFDEF VER140},DesignIntf, DesignEditors{$ENDIF}
  {$IFDEF VER120},DsgnIntf{$ENDIF}
  {$IFDEF VER130},DsgnIntf{$ENDIF};

{ TGTRODBDateTimePickerDataFieldEditor }

{*******************************************************************************
Notes       : A custom property editor was required for the DataField property
            : to avoid selecting fields that cannot contain date formats.
            : The selection rule is as follows:
            : if Kind = dtkDate then fields of types ftDateTime and ftDate can
            : accessed;
            : if Kind = dtkTime then fields of types ftDateTime and ftTime can
            : be accessed.
*******************************************************************************}
type
  TGtroDBDateTimePickerDataFieldEditor = class(TStringProperty)
	public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TGtroDBDateTimePickerDataFieldEditor.GetAttributes: TPropertyAttributes;
begin
  Result:= [paAutoUpdate, paMultiSelect, paValueList, paSortList];
end;

procedure TGtroDBDateTimePickerDataFieldEditor.GetValues(Proc: TGetStrProc);
var
  SList: TStringList;
  Picker: TGtroDBDateTimePicker;
  i: Integer;
  Field: TField;
begin
  SList:= TStringList.Create;
  try
    Picker:= GetComponent(0) as TGtroDBDateTimePicker;
    if Assigned(Picker.DataSource) and
      Assigned(Picker.DataSource.DataSet) then
    begin
      Picker.DataSource.DataSet.GetFieldNames(SList);
      for i:= 0 to SList.Count - 1 do
      begin
        if Picker.DataSource.DataSet.Active then
          Field:= Picker.DataSource.DataSet.Fields[i]
				else
					Field:= Picker.DataSource.DataSet.FieldDefs.Items[i].CreateField(nil);
        if Picker.Kind = dtkDate then
          if ((Field.DataType = ftDate) or (Field.DataType = ftDateTime)) then
              Proc(SList.Strings[i]);
        if Picker.Kind = dtkTime then
          if ((Field.DataType = ftTime) or (Field.DataType = ftDateTime)) then
              Proc(SList.Strings[i]);
				if not Picker.DataSource.DataSet.Active then Field.Free;
      end;
    end;
  finally
    SList.Free;
  end;
end;

{ TGtroDBDateTimePickerComponentEditor }

{ TGtroDBTreeViewKeyDataFieldEditor }

type
  TGtroDBTreeViewKeyDataFieldEditor = class(TStringProperty)
	public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TGtroDBTreeViewKeyDataFieldEditor.GetAttributes: TPropertyAttributes;
begin
  Result:= [paAutoUpdate, paMultiSelect, paValueList, paSortList];
end;

procedure TGtroDBTreeViewKeyDataFieldEditor.GetValues(Proc: TGetStrProc);
var
  SList: TStringList;
  TView: TGtroDBTreeView;
  i: Integer;
  Field: TField;
begin
  SList:= TStringList.Create;
  try
    TView:= GetComponent(0) as TGtroDBTreeView; // fetch TGtroDBTreeView component
    if Assigned(TView.DataSource) and
      Assigned(TView.DataSource.DataSet) then
    begin // compile a list of fields only if component is connected correctly
      TView.DataSource.DataSet.GetFieldNames(SList);
      for i:= 0 to SList.Count - 1 do
      begin
        if TView.DataSource.DataSet.Active then
          Field:= TView.DataSource.DataSet.Fields[i]
				else
					Field:= TView.DataSource.DataSet.FieldDefs.Items[i].CreateField(nil);
          if ((Field.DataType = ftSmallint)
          or  (Field.DataType = ftInteger)
          or  (Field.DataType = ftAutoInc))
          and (Field.Index = 0) then
            Proc(SList.Strings[i]);
				if not TView.DataSource.DataSet.Active then Field.Free;
      end;
    end;
  finally
    SList.Free;
  end;
end;

{ TGtroDBTreeViewParentDataFieldEditor }

type
  TGtroDBTreeViewParentDataFieldEditor = class(TStringProperty)
	public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TGtroDBTreeViewParentDataFieldEditor.GetAttributes: TPropertyAttributes;
begin
  Result:= [paAutoUpdate, paMultiSelect, paValueList, paSortList];
end;

procedure TGtroDBTreeViewParentDataFieldEditor.GetValues(Proc: TGetStrProc);
var
  SList: TStringList;
  TView: TGtroDBTreeView;
  i: Integer;
  Field: TField;
begin
  SList:= TStringList.Create;
  try
    TView:= GetComponent(0) as TGtroDBTreeView;
    if Assigned(TView.DataSource) and
      Assigned(TView.DataSource.DataSet) then
    begin
      TView.DataSource.DataSet.GetFieldNames(SList);
      for i:= 0 to SList.Count - 1 do
      begin
        if TView.DataSource.DataSet.Active then
          Field:= TView.DataSource.DataSet.Fields[i]
				else
					Field:= TView.DataSource.DataSet.FieldDefs.Items[i].CreateField(nil);
        if ((Field.DataType = ftSmallint)
        or  (Field.DataType = ftInteger) or
            (Field.DataType = ftInteger))
        and (Field.Index <> 0) then
            Proc(SList.Strings[i]);
				if not TView.DataSource.DataSet.Active then Field.Free;
      end;
    end;
  finally
    SList.Free;
  end;
end;

{ TGtroDBTreeViewIsFolderDataFieldEditor }

type
  TGtroDBTreeViewIsFolderDataFieldEditor = class(TStringProperty)
	public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TGtroDBTreeViewIsFolderDataFieldEditor.GetAttributes: TPropertyAttributes;
begin
  Result:= [paAutoUpdate, paMultiSelect, paValueList, paSortList];
end;

procedure TGtroDBTreeViewIsFolderDataFieldEditor.GetValues(Proc: TGetStrProc);
var
  SList: TStringList;
  TView: TGtroDBTreeView;
  i: Integer;
  Field: TField;
begin
  SList:= TStringList.Create;
  try
    TView:= GetComponent(0) as TGtroDBTreeView;
    if Assigned(TView.DataSource) and
      Assigned(TView.DataSource.DataSet) then
    begin
      TView.DataSource.DataSet.GetFieldNames(SList);
      for i:= 0 to SList.Count - 1 do
      begin
        if TView.DataSource.DataSet.Active then
          Field:= TView.DataSource.DataSet.Fields[i]
				else
					Field:= TView.DataSource.DataSet.FieldDefs.Items[i].CreateField(nil);
        if Field.DataType = ftBoolean then Proc(SList.Strings[i]);
				if not TView.DataSource.DataSet.Active then Field.Free;
      end;
    end;
  finally
    SList.Free;
  end;
end;

{ TGtroDBTreeViewTitleDataFieldEditor }

type
  TGtroDBTreeViewLabelDataFieldEditor = class(TStringProperty)
	public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TGtroDBTreeViewLabelDataFieldEditor.GetAttributes: TPropertyAttributes;
begin
  Result:= [paAutoUpdate, paMultiSelect, paValueList, paSortList];
end;

procedure TGtroDBTreeViewLabelDataFieldEditor.GetValues(Proc: TGetStrProc);
var
  SList: TStringList;
  TView: TGtroDBTreeView;
  i: Integer;
  Field: TField;
begin
  SList:= TStringList.Create;
  try
    TView:= GetComponent(0) as TGtroDBTreeView;
    if Assigned(TView.DataSource) and
      Assigned(TView.DataSource.DataSet) then
    begin
      TView.DataSource.DataSet.GetFieldNames(SList);
      for i:= 0 to SList.Count - 1 do
      begin
        if TView.DataSource.DataSet.Active then
          Field:= TView.DataSource.DataSet.Fields[i]
				else
					Field:= TView.DataSource.DataSet.FieldDefs.Items[i].CreateField(nil);
        if Field.DataType = ftString then Proc(SList.Strings[i]);
				if not TView.DataSource.DataSet.Active then Field.Free;
      end;
    end;
  finally
    SList.Free;
  end;
end;

{ TGtroDBPushButtonCalendarDataFieldEditor }

{*******************************************************************************
Notes       : A custom property editor was required for the DataField property
            : to avoid selecting fields that cannot contain date formats.
            : The selection rule is as follows:
            : if Kind = dtkDate then fields of types ftDateTime and ftDate can
            : accessed;
            : if Kind = dtkTime then fields of types ftDateTime and ftTime can
            : be accessed.
*******************************************************************************}
type
  TGtroDBPushButtonCalendarDataFieldEditor = class(TStringProperty)
	public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

function TGtroDBPushButtonCalendarDataFieldEditor.GetAttributes: TPropertyAttributes;
begin
  Result:= [paAutoUpdate, paMultiSelect, paValueList, paSortList];
end;

procedure TGtroDBPushButtonCalendarDataFieldEditor.GetValues(Proc: TGetStrProc);
var
  SList: TStringList;
  Cal: TGtroDBPushButtonCalendar;
  i: Integer;
  Field: TField;
begin
  SList:= TStringList.Create;
  try
    Cal:= GetComponent(0) as TGtroDBPushButtonCalendar;
    if Assigned(Cal.DataSource) and
      Assigned(Cal.DataSource.DataSet) then
    begin
      Cal.DataSource.DataSet.GetFieldNames(SList);
      for i:= 0 to SList.Count - 1 do
      begin
        if Cal.DataSource.DataSet.Active then
          Field:= Cal.DataSource.DataSet.Fields[i]
				else
					Field:= Cal.DataSource.DataSet.FieldDefs.Items[i].CreateField(nil);
        if (Field.DataType = ftDateTime)
        or (Field.DataType = ftDate)  then Proc(SList.Strings[i]);
				if not Cal.DataSource.DataSet.Active then Field.Free;
      end;
    end;
  finally
    SList.Free;
  end;
end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(string), TGtroDBDateTimePicker, 'DataField',
    TGtroDBDateTimePickerDataFieldEditor);
  RegisterPropertyEditor(TypeInfo(string), TGtroDBTreeView,
    'KeyFieldName', TGtroDBTreeViewKeyDataFieldEditor);
  RegisterPropertyEditor(TypeInfo(string), TGtroDBTreeView,
    'ParentFieldName', TGtroDBTreeViewParentDataFieldEditor);
  RegisterPropertyEditor(TypeInfo(string), TGtroDBTreeView,
    'IsFolderFieldName', TGtroDBTreeViewIsFolderDataFieldEditor);
  RegisterPropertyEditor(TypeInfo(string), TGtroDBTreeView,
    'LabelFieldName', TGtroDBTreeViewLabelDataFieldEditor);
  RegisterPropertyEditor(TypeInfo(string), TGtroDBPushButtonCalendar, 'FieldName',
    TGtroDBPushButtonCalendarDataFieldEditor);
  RegisterPropertyEditor(TypeInfo(string), TGtroDBTreeView,
    'KeyFieldName', TGtroDBTreeViewKeyDataFieldEditor);
  RegisterPropertyEditor(TypeInfo(string), TGtroDBTreeView,
    'ParentFieldName', TGtroDBTreeViewParentDataFieldEditor);
  RegisterPropertyEditor(TypeInfo(string), TGtroDBTreeView,
    'IsFolderFieldName', TGtroDBTreeViewIsFolderDataFieldEditor);
end;

end.
